<?php
/* --------------------------------------------------------------
   DeleteWithdrawalsAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Withdrawal\Actions;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalService;
use Gambio\Admin\Withdrawal\Models\WithdrawalId;
use Gambio\Admin\Withdrawal\Models\WithdrawalIds;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class DeleteWithdrawalsAction
 *
 * @package Gambio\Api\Withdrawal\Actions
 */
class DeleteWithdrawalsAction
{
    /**
     * @var WithdrawalService
     */
    private $service;
    
    
    /**
     * DeleteWithdrawalsAction constructor.
     *
     * @param WithdrawalService $service
     */
    public function __construct(WithdrawalService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        $ids = [];
        if ($request->getAttribute('ids') !== null) {
            foreach (explode(',', $request->getAttribute('ids')) as $id) {
                $ids[] = WithdrawalId::create((int)$id);
            }
        }
        
        $this->service->deleteWithdrawals(WithdrawalIds::create(...$ids));
        
        return $response->withStatus(204);
    }
}